local config = {
  exeta = "exeta res",
  minMonsters = 1,
  monsterDist = 1,
  tryDelay = 3000
}

local s = { }
local savedPosition = nil
local returning = false

s.getPositions = function()
  local members = { }
  local mobs = { }
  for _, spec in ipairs(getSpectators(posz())) do
    if spec:isPlayer() and spec:isPartyMember() and spec ~= player then
      table.insert(members, spec:getPosition())
    elseif spec:isMonster() then
      table.insert(mobs, spec:getPosition())
    end
  end
  return members, mobs
end

local walkTo = nil
s.m_macro = macro(500, "Exeta PT", function(m)
  
  if not walkTo and not returning then
    local members, mobs = s.getPositions()
    for _, mobPos in ipairs(mobs) do
      for _, memPos in ipairs(members) do
        local dist = getDistanceBetween(mobPos, memPos)
        if dist <= config.monsterDist then
          savedPosition = pos()
          walkTo = mobPos          
          break
        end
      end
      if walkTo then break end
    end
  end
  
  if walkTo and not returning then
    autoWalk(walkTo, 20, { precision = 2, ignoreNonPathable = true })
    if getDistanceBetween(walkTo, pos()) <= 1 then
      walkTo = nil
      say(config.exeta)      
      returning = true
    end
  end
  
  if returning then
    autoWalk(savedPosition, 20, { precision = 2, ignoreNonPathable = true })
    if getDistanceBetween(savedPosition, pos()) <= 1 then
      savedPosition = nil
      returning = false
      delay(config.tryDelay)
    end
  end
end)

addIcon("exetaBossIcon", {item={id=655, count=1}, text="ExetaBoss"}, s.m_macro)



local c = getCreatureByName("GOD")

UI.Button("teste", function()
  c:setText("xx")
  c:show()
  print(string.dump(c))
  
end)



local colors = {
  "#FF0000", -- Red
  "#00FF00", -- Lime
  "#0000FF", -- Blue
  "#FFFF00", -- Yellow
  "#FFA500", -- Orange
  "#800080", -- Purple
  "#00FFFF", -- Aqua/Cyan
  "#FFC0CB", -- Pink
  "#808080", -- Gray
  "#800000", -- Maroon
  "#808000", -- Olive
  "#008000", -- Green
  "#008080", -- Teal
  "#000080", -- Navy
  "#FFFFFF", -- White
  "#000000", -- Black
  "#A52A2A", -- Brown
  "#8A2BE2", -- Blue Violet
  "#5F9EA0", -- Cadet Blue
  "#7FFF00", -- Chartreuse
  "#D2691E", -- Chocolate
  "#FF7F50", -- Coral
  "#6495ED", -- Cornflower Blue
  "#DC143C", -- Crimson
  "#00CED1", -- Dark Turquoise
  "#9400D3", -- Dark Violet
  "#FFD700", -- Gold
  "#ADFF2F", -- Green Yellow
  "#FF69B4", -- Hot Pink
  "#CD5C5C", -- Indian Red
  "#4B0082", -- Indigo
  "#F0E68C", -- Khaki
  "#E6E6FA", -- Lavender
  "#FFB6C1", -- Light Pink
  "#20B2AA", -- Light Sea Green
  "#7B68EE", -- Medium Slate Blue
  "#3CB371", -- Medium Sea Green
  "#48D1CC", -- Medium Turquoise
  "#C71585", -- Medium Violet Red
  "#191970", -- Midnight Blue
  "#FFE4B5", -- Moccasin
  "#FFDEAD", -- Navajo White
  "#FDF5E6", -- Old Lace
  "#FF4500", -- Orange Red
  "#DA70D6", -- Orchid
  "#EEE8AA", -- Pale Goldenrod
  "#98FB98", -- Pale Green
  "#AFEEEE", -- Pale Turquoise
  "#DB7093", -- Pale Violet Red
  "#FFEFD5", -- Papaya Whip
  "#FFDAB9", -- Peach Puff
  "#CD853F", -- Peru
  "#BC8F8F", -- Rosy Brown
  "#4169E1", -- Royal Blue
  "#8B4513", -- Saddle Brown
  "#FA8072", -- Salmon
  "#F4A460", -- Sandy Brown
  "#2E8B57", -- Sea Green
  "#A0522D", -- Sienna
  "#87CEEB", -- Sky Blue
  "#6A5ACD", -- Slate Blue
  "#708090", -- Slate Gray
  "#FFFAFA", -- Snow
  "#4682B4", -- Steel Blue
  "#D2B48C", -- Tan
  "#D8BFD8", -- Thistle
  "#FF6347", -- Tomato
  "#40E0D0", -- Turquoise
  "#EE82EE", -- Violet
  "#F5DEB3", -- Wheat
  "#9ACD32", -- Yellow Green
}